#ifndef __PLX_INTERRUPT_H
#define __PLX_INTERRUPT_H

/*******************************************************************************
 * Copyright (c) PLX Technology, Inc.
 *
 * PLX Technology Inc. licenses this source file under the GNU Lesser General Public
 * License (LGPL) version 2.  This source file may be modified or redistributed
 * under the terms of the LGPL and without express permission from PLX Technology.
 *
 * PLX Technology, Inc. provides this software AS IS, WITHOUT ANY WARRANTY,
 * EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  PLX makes no guarantee
 * or representations regarding the use of, or the results of the use of,
 * the software and documentation in terms of correctness, accuracy,
 * reliability, currentness, or otherwise; and you rely on the software,
 * documentation and results solely at your own risk.
 *
 * IN NO EVENT SHALL PLX BE LIABLE FOR ANY LOSS OF USE, LOSS OF BUSINESS,
 * LOSS OF PROFITS, INDIRECT, INCIDENTAL, SPECIAL OR CONSEQUENTIAL DAMAGES
 * OF ANY KIND.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * File Name:
 *
 *      PlxInterrupt.h
 *
 * Description:
 *
 *      Driver interrupt functions
 *
 * Revision History:
 *
 *      10-01-10 : PLX SDK v6.40
 *
 ******************************************************************************/


#include "PlxTypes.h"




/**********************************************
*               Definitions
**********************************************/
#define INTR_TYPE_NONE                  0              // Interrupt identifiers
#define INTR_TYPE_DESCR_DMA_DONE        (1 << 1)
#define INTR_TYPE_PAUSE_DONE            (1 << 2)
#define INTR_TYPE_ABORT_DONE            (1 << 3)
#define INTR_TYPE_IMMED_STOP_DONE       (1 << 4)
#define INTR_TYPE_DESCR_INVALID         (1 << 5)
#define INTR_TYPE_DMA_ERROR             (1 << 6)




/**********************************************
*               Functions
**********************************************/
KSERVICE_ROUTINE  OnInterrupt;
KDEFERRED_ROUTINE DpcForIsr;



#endif
