// 2003.08.10
//****************************************
//**  Copyright  (C)  W.ch  1999-2003   **
//**  Web:  http://www.winchiphead.com  **
//****************************************
//**  WDM for PCI interface chip CH365  **
//**  C, VC5.0, Windows 98 DDK          **
//****************************************
//
// PCI߽ӿоƬCH365WDM   V1.0
// Ͼߺ޹˾  : W.ch 2003.08
// CH365-WDM  V1.0 ,    Support: IO/MEM/INT
// л: Windows 98/ME, Windows 2000/XP
//

#ifndef		_CAN_WDM_H
#define		_CAN_WDM_H


#define		mOFFSET( s, m )			( (ULONG) & ( ( ( s * ) 0 ) -> m ) )	// ȡṹԱƫƵַĺ

#ifndef		max
#define		max( a, b )				( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )	// ϴֵ
#endif

#ifndef		min
#define		min( a, b )				( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )	// Сֵ
#endif

#ifdef		ExAllocatePool
#undef		ExAllocatePool						// ɾTAGڴ
#endif

#ifndef		NTSTATUS
typedef		LONG	NTSTATUS;					// ״̬
#endif


typedef	struct	_PCI_CONFIG {					// PCIÿռݽṹ
	USHORT			mPcVendorId;				// 00H Ӧ̱ʶ
	USHORT			mPcDeviceId;				// 02H 豸ʶ
	USHORT			mPcCommandReg;				// 04H Ĵ
	USHORT			mPcStatusReg;				// 06H ״̬Ĵ
	UCHAR			mPcRevisionId;				// 08H ޸ıʶ
	UCHAR			mPcProgramIf;				// 09H Ĵ̽ӿ
	UCHAR			mPcSubClass;				// 0AH 
	UCHAR			mPcBaseClass;				// 0BH 
	UCHAR			mPcCacheLine;				// 0CH г
	UCHAR			mPcLatenTimer;				// 0DH ӳټ
	UCHAR			mPcHeaderType;				// 0EH ͷ
	UCHAR			mPcBistReg;					// 0FH ںԲԼĴ
	ULONG			mPcBaseAddr0;				// 10H ַĴ0
	ULONG			mPcBaseAddr1;				// 14H ַĴ1
	ULONG			mPcBaseAddr2;				// 18H ַĴ2
	ULONG			mPcBaseAddr3;				// 1CH ַĴ3
	ULONG			mPcBaseAddr4;				// 20H ַĴ4
	ULONG			mPcBaseAddr5;				// 24H ַĴ5
	ULONG			mPcCardCis;					// 28H
	USHORT			mPcSubSysVen;				// 2CH ϵͳӦ̱ʶ
	USHORT			mPcSubSysDev;				// 2EH ϵͳ豸ʶ
	ULONG			mPcExpansRom;				// 30H չROMַĴ
	UCHAR			mPcCapPtr;					// 34H
	UCHAR			mPcReserved1[3];			// 35H
	ULONG			mPcReserved2;				// 38H
	UCHAR			mPcInterLine;				// 3CH ж߼Ĵ
	UCHAR			mPcInterPin;				// 3DH жżĴ
	UCHAR			mPcMinGrant;				// 3EH
	UCHAR			mPcMaxLatency;				// 3FH
} mPCI_CONFIG, *mPPCI_CONFIG;

typedef	struct	_PCI_EXP_ROM {					// PCIչROMݽṹ
	UCHAR			mPerRomSig[4];				// 00H PCIչROMǩַ'PCIR'
	USHORT			mPerVendorId;				// 04H Ӧ̱ʶ
	USHORT			mPerDeviceId;				// 06H 豸ʶ
	USHORT			mPerVpdPtr;					// 08H ҪƷָ
	USHORT			mPerStrucLen;				// 0AH PCIչROMݽṹĳ
	UCHAR			mPerRevision;				// 0CH PCIչROMݽṹ޸İ汾
	UCHAR			mPerProgramIf;				// 0DH Ĵ̽ӿ
	UCHAR			mPerSubClass;				// 0EH 
	UCHAR			mPerBaseClass;				// 0FH 
	USHORT			mPerImageLen;				// 10H ӳ񳤶
	USHORT			mPerImageRev;				// 12H ӳд/ݵ޸İ汾
	UCHAR			mPerCodeType;				// 14H 
	UCHAR			mPerIndicator;				// 15H ӳָʾ־
	USHORT			mPerReserved;				// 16H
} mPCI_EXP_ROM, *mPPCI_EXP_ROM;

typedef	struct	_CH365_CFG_REG {				// CH365оƬüĴ
	mPCI_CONFIG		mCh365CfgPci;				// 00H-3FH,64ֽΪ׼PCIÿռ
	UCHAR			mCh365CfgCtrl;				// 40H оƬƼĴ,5λֻ
	UCHAR			mCh365CfgDin;				// 41H 8λ˿,ֻ
	UCHAR			mCh365CfgState;				// 42H оƬ״̬Ĵ,ֻ
	UCHAR			mCh365CfgResv;				// 43H
} mCH365_CFG_REG, *mPCH365_CFG_REG;

typedef	struct	_CH365_IO_REG {					// CH365оƬI/Oռ
	UCHAR			mCh365IoPort[0xf0];			// 00H-EFH,240ֽΪ׼I/O˿
	union	{									// ֻֽΪλдȡ
		USHORT		mCh365MemAddr;				// F0H 洢ӿ: A15-A0ַ趨Ĵ
		struct	{								// ֽΪλдȡ
			UCHAR	mCh365MemAddrL;				// F0H 洢ӿ: A7-A0ַ趨Ĵ
			UCHAR	mCh365MemAddrH;				// F1H 洢ӿ: A15-A8ַ趨Ĵ
		};
	};
	UCHAR			mCh365IoResv2;				// F2H
	UCHAR			mCh365MemData;				// F3H 洢ӿ: 洢ݴȡĴ
	UCHAR			mCh365I2cData;				// F4H I2Cнӿ: I2CݴȡĴ
	UCHAR			mCh365I2cCtrl;				// F5H I2Cнӿ: I2Cƺ״̬Ĵ
	UCHAR			mCh365I2cAddr;				// F6H I2Cнӿ: I2Cַ趨Ĵ
	UCHAR			mCh365I2cDev;				// F7H I2Cнӿ: I2C豸ַĴ
	UCHAR			mCh365IoCtrl;				// F8H оƬƼĴ,5λֻ
	UCHAR			mCh365IoBuf;				// F9H 뻺Ĵ
	UCHAR			mCh365Speed;				// FAH оƬٶȿƼĴ
	UCHAR			mCh365IoResv3;				// FBH
	UCHAR			mCh365IoTime;				// FCH ӲѭĴ
	UCHAR			mCh365IoResv4[3];			// FDH
} mCH365_IO_REG, *mPCH365_IO_REG;

typedef	struct	_CH365_MEM_REG {				// CH365оƬĴ洢ռ
	UCHAR			mCh365MemPort[0x8000];		// 0000H-7FFFH,32768ֽΪ׼Ĵ洢Ԫ
} mCH365_MEM_REG, *mPCH365_MEM_REG;

typedef	struct	_WIN32_COMMAND {				// WIN32ӿڽṹ
	union	{
		ULONG		mFunction;					// ʱָܴ
		NTSTATUS	mStatus;					// ʱز״̬
	};
	PVOID			mAddress;					// ʼַ,صַ
	ULONG			mLength;					// ȡ,غݵĳ
	UCHAR			mBuffer[16];					// ݻ,Ϊ032KB
} mWIN32_COMMAND, *mPWIN32_COMMAND;


typedef struct _Can_FRAME{

		UCHAR		ExF_StartFrame;		//ʼ֡
		UCHAR		ExF_IDRegion;		//
		UCHAR		ExF_IDSub;			//
		UCHAR		ExF_Func;			//ܴ
		UCHAR		ExF_Func_Ex;		//ģʽģʽչ0xff@@(λ޹)
		UCHAR		ExF_DATA[8];		//8λ

} m_Can_Frame,* p_Can_Frame;

typedef struct _Rece_Buffer{
m_Can_Frame		* Frame	;	//13λ֡
volatile	int		 Head_op	;	 //ָ
volatile	int		Tail_op	;
int                         m_Max_Rece_Len;
} m_ReceBuffer,		*p_ReceBuffer;


// WIN32Ӧòӿ
#define		IOCTL_CH365_COMMAND		( FILE_DEVICE_UNKNOWN << 16 | FILE_ANY_ACCESS << 14 | 0x0f36 << 2 | METHOD_BUFFERED )	// רýӿ

#define		mWIN32_COMMAND_HEAD		mOFFSET( mWIN32_COMMAND, mBuffer )	// WIN32ӿڵͷ

#define		mCH365_MAX_NUMBER		16			// ͬʱӵCH365

#define		mMAX_BUFFER_LENGTH		max( sizeof( mCH365_IO_REG ), sizeof( mCH365_MEM_REG ) )	// ݻ󳤶

#define		mMAX_COMMAND_LENGTH		( mWIN32_COMMAND_HEAD + mMAX_BUFFER_LENGTH )	// ݳȼṹͷĳ

#define		mCH365_MEM_BASE_AUTO		( (PVOID)0xffffffff )	// Զ趨CH365Ĵ洢ַ

#define		mCH365_INT_LINE_AUTO			0xffffffff				// ԶCH365жϺ

#define         MAX_RECE_BUFFER_SIZE                 102400
// Ĵλ
#define		mBitAddr15Out			0x01		// 趨A15ֵ,1*:high,0:low
#define		mBitSysExtOut			0x02		// 趨SYS_EXֵ,1:high,0*:low
#define		mBitIntAction			0x04		// 趨жϼ״̬,1:action,0*:inaction
#define		mBitPciIdDef			0x01		// ֻ,PCI豸ʶĵǰѡ,1*:default,0:external
#define		mBitPortHit			0x04		// ֻ,Ӳַܵ״̬,1:,0*:
#define		mBitInterRom			0x10		// ֻ,ڲMini-ROMܵ״̬,1:,0*:
#define		mBitSysExtOe			0x40		// ֻ,SYS_EX̬/ʹ,1*:,0:
#define		mBitIntEnable			0x80		// ֻ,жϹܵ״̬,1:,0*:
#define		mBitI2cStatus			0x01		// I2CӿڵĲƺ״̬,1:ʼ/ڲ,0*:/
#define		mBitI2cSclOut			0x80		// ѡI2CӿڵSCL,1:SYS_EX,0*:A15
#define		mBitSpeedAct			0x07		// ٶȿ,״̬,ʵʿΪֵ30nS
#define		mBitSpeedInact			0x10		// ٶȿ,Ǽ״̬Ŀп,1:ǰ45nS/15nS,0:ǰ15nS/15nS
#define		mBitSpeedPreft			0x80		// ٶȿ,Ԥȡ״̬λ,1:ԤȡλЧ,0:ԤȡλЧ


// ӦòӿڵĹܴ
#define		mFuncNoOperation		0x00000000	// ޲
#define		mFuncGetVersion			0x00000001	// ȡ汾
#define		mFuncGetIoBaseAddr		0x00000002	// ȡI/O˿ڻַ
#define		mFuncGetMemBaseAddr		0x00000003	// ȡ洢ַ
#define         mFuncCanInitialize		0x00000004      // CAN豸ʼ
#define         mFuncCanReceive	  		0x00000005      // CAN豸
#define         mFuncCanSend			0x00000006	// CAN豸
#define 	mFuncSetInterLine		0x00000007      // 豸ж߳
#define   	mFuncWaitingSend           	0x00000008
#define   	mFuncWaitingReceive           	0x00000009
#define     	mFuncGetInterLine        	0x0000000a
#define         mFuncAbortWaitInter		0x0000000b	
//CAN CONTROLER REGISTER DEFINE
#define		ModeRegister_Addr				0x00		/*MOD						*/  
#define		CmdRegister_Addr				0x01		/*CMR						*/
#define		StateRegister_Addr				0x02		/*SR						*/
#define		IntRegister_Addr				0x03		/*IR						*/
#define		IntEnRegister_Addr				0x04		/*IER						*/
#define		BusTimeRegister0_Addr			0x06		/*BTR0						*/
#define		BusTimeRegister1_Addr			0x07		/*BTR1						*/
#define		OutPutCtrRegister_Addr			0x08		/*OCR						*/
#define		ArbitrationLCatch_Addr			0x0B		/*ALC Read Only					*/
#define		ErrorCCRegister_Addr			0x0C		/*ECC						*/
#define		ErrorWarningLR_Addr			0x0D		/*EWLR						*/
#define		RXERRegister_Addr				0x0E		/*RXERR						*/
#define		TXERRegister_Addr				0x0F		/*TXERR						*/
#define		SFFIDBuffer_Addr				0x10		/*BID*2						*/
#define		EFFIDBuffer_Addr				0x10		/*BID*4						*/
#define		SFF_DATA						0x13		/*SFF						*/
#define		EFF_DATA						0x15		/*EFF						*/
#define		RXRamBuffer_Addr				0x1E		/*RBSA						*/
#define		CDR_Addr						0x1F		/*CDR						*/
#define		ACR0_Addr						0x10		/*ACR0						*/
#define		ACR1_Addr						0x11		/*ACR1						*/
#define		ACR2_Addr						0x12		/*ACR2						*/
#define		ACR3_Addr						0x13		/*ACR3						*/
#define		AMR0_Addr						0x14		/*AMR0						*/
#define		AMR1_Addr						0x15		/*AMR1						*/
#define		AMR2_Addr						0x16		/*AMR2						*/
#define		AMR3_Addr						0x17		/*AMR3						*/

////////////////////////////////////////////////////////////////////////////////////////

/**************CFG Define******************************************************************/
/*MOD_CFG*/
#define		MOD_RM						0x01		/*λģʽ					*/
#define		MOD_LOM					0x02		/*ֻģʽ					*/
#define		MOD_STM					0x04		/*Լģʽ					*/
#define		MOD_AFM					0x08		/*˲ģʽ				*/
#define		MOD_SM						0x10		/*˯ģʽ					*/
/*CMR_CFG*/
#define		CMR_TR						0x01		/*					*/
#define		CMR_AT						0x02		/*ֹ					*/
#define		CMR_RR						0x04		/*ͷŽջ				 	*/
#define		CMR_CDO					0x08		/*					*/
#define		CMR_SRR					0x10		/*Զģʽ					*/
/*IR*/
#define		RI_RI						0x01		/*ж					*/
#define		RI_TI						0x02		/*ж					*/
#define		RI_EI						0x04		/*ж					*/
#define		RI_DOI						0x08		/*ж					*/
#define		RI_WUI						0x10		/*ж					*/
#define		RI_EPI						0x20		/*Ͽж					*/
#define		RI_ALI						0x40		/*ٲöʧж					*/
#define		RI_BEI						0x80		/*ߴж					*/	
/*SR*/
#define		SR_RBS						0x01		/*ջ״̬ 1Ч			*/
#define		SR_DOS						0x02		/*״̬	RXFIFO				*/
#define		SR_TBS						0x04		/*ͻ״̬ 1CPU򻺳ͱ	*/
#define		SR_TCS						0x08		/*״̬1η		*/
#define		SR_RS						0x10		/*״̬	1ڽ			*/
#define		SR_TS						0x20		/*״̬	1ڷ			*/
#define		SR_ES						0x40		/*״̬	1һ	*/
#define		SR_BS						0x80		/*״̬  1ر				*/
/*IER*/
#define		IER_RIE						0x01		/*жʹ					*/
#define		IER_TIE						0x02		/*жʹ					*/
#define		IER_ELE						0x04		/*жʹ				*/
#define		IER_DOIE					0x08		/*жʹ				*/
#define		IER_WUIE					0x10		/*жʹ					*/
#define		IER_EPIE					0x20		/*Ͽжʹ				*/
#define		IER_ALIE					0x40		/*ٲöʧжʹ				*/
#define		IER_BEIE					0x80		/*ߴжʹ				*/
/*ERRO*/
#define		ALC_MASK					0x1F		/*ٲöʧ׽				*/
#define		ECC_ERRC_MASK				0xC0		/*ͱ00011011λʽ*/
#define		ECC_DIR_MASK				0x20		/*λRX1TX0				*/
#define		ECC_SEG_MASK				0x1F		/*					*/
/*DLC*/
#define		STFrame_FF_MASK			0x80		/*֡ṹʶ					*/
#define		STFrame_RTR_MASK			0x40		/*Զ֡ʶ					*/
/*CDR*/
#define		CDR_Clock_OFF				0x08		/*رⲿʱ				*/	
#define		CDR_CBP_RX0				0x40		/*·Ƚ					*/
#define		CDR_Mode_Switch			0x80		/*BasicCAN					*/
/*SELF DEFINE */
#define		GetDataLength(ID)			(ID&0x0F)	/*ȡ֡ */
UCHAR         CanIntEn= 0x73;

//{5EA71865-00F6-4fbf-9B19-FC58C894A261}
static const GUID  CanGuid= { 0x5ea71865, 0xf6, 0x4fbf, { 0x9b, 0x19, 0xfc, 0x58, 0xc8, 0x94, 0xa2, 0x61 } };

#endif		// _CAN_WDM_H
